//
//  AHKABDoubleEntriesWindowController.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Mon Jun 6 2005.
//  Copyright (c) 2005 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABDoubleEntriesWindowController.h"
#import "AHKABMainWindowController.h"
//#import "AHKPerson.h"

@implementation AHKABDoubleEntriesWindowController

#pragma mark class methods
+ (id)sharedWindowControllerWithMainWindowController:(AHKABMainWindowController *)aMainWindowController
{
	static AHKABDoubleEntriesWindowController *sharedWindowController;
	if (sharedWindowController == nil) {
		sharedWindowController = [[AHKABDoubleEntriesWindowController alloc] initWithMainWindowController:aMainWindowController];
	}
	return sharedWindowController;
}

#pragma mark initialization and deallocation
- (id)initWithMainWindowController:(AHKABMainWindowController *)aWindowController
{
	self = [self initWithWindowNibName:@"AHKABDoubleEntriesWindow"];
	if (self) {
		// weak reference (not retain)
		windowController = aWindowController;
		[self setWindowFrameAutosaveName:@"AHKABDoubleEntriesWindow"];
		
		dataSource = [[NSArray alloc] init];
	}
	return self;
}

- (void)windowDidLoad
{
	[outlineView setDoubleAction:@selector(findSelection:)];

}

- (void)dealloc
{
	[dataSource release];
	
	[super dealloc];
}

#pragma mark implementation fof NSOutlineViewDataSource (informal protocol)

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
	return (item == nil) ? [dataSource objectAtIndex:index] : [item objectAtIndex:index];
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	if (item == nil || [item isKindOfClass:[NSArray class]]) {
		return YES;
	}
	return NO;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
    return (item == nil) ? [dataSource count] : [item count];
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
	if (item == [dataSource objectAtIndex:0]) {
		NSString *message = NSLocalizedStringFromTable(@"duplicate phone numbers: %d items", @"AHKABLocalizable", @"doubleEntries.outlineView.phones");
		return [NSString stringWithFormat:message, [item count]];
	} else if (item == [dataSource objectAtIndex:1]) {
		NSString *message = NSLocalizedStringFromTable(@"duplicate mail addresses: %d items", @"AHKABLocalizable", @"doubleEntries.outlineView.emails");
		return [NSString stringWithFormat:message, [item count]];
	} else {
		return [item description];
	}
}

#pragma mark Delegate methods

- (BOOL)outlineView:(NSOutlineView *)outlineView shouldEditTableColumn:(NSTableColumn *)tableColumn item:(id)item
{
	return NO;
}

#pragma mark IBActions
- (IBAction)checkDoubleEntries:(id)sender
{
	NSArray			*people				= [windowController people];
	NSMutableSet	*allPhonesSet		= [NSMutableSet setWithCapacity:([people count] * 3)];
	NSMutableSet	*allEmailsSet		= [NSMutableSet setWithCapacity:([people count] * 3)];
	NSMutableSet	*doubledPhonesSet	= [NSMutableSet setWithCapacity:3];
	NSMutableSet	*doubledEmailsSet	= [NSMutableSet setWithCapacity:3];
	
	NSArray			*phoneValueKeys		= [NSArray arrayWithObjects:@"phones.firstValue",
		@"phones.secondValue",
		@"phones.thirdValue",
		nil];
	NSArray			*emailValueKeys		= [NSArray arrayWithObjects:@"emails.firstValue",
		@"emails.secondValue", 
		@"emails.thirdValue", 
		nil];
		
	NSEnumerator	*peopleEnumerator;
	NSEnumerator	*phoneKeysEnumerator;
	NSEnumerator	*emailKeysEnumerator;
	id				person;
	id				key, value;
	
	peopleEnumerator = [people objectEnumerator];
	
	while (person = [peopleEnumerator nextObject]) {
		phoneKeysEnumerator = [phoneValueKeys objectEnumerator];
		while (key = [phoneKeysEnumerator nextObject]) {
			if (value = [person valueForKeyPath:key]) {
				if ([allPhonesSet containsObject:value]) {
					[doubledPhonesSet addObject:value];
				}
				[allPhonesSet addObject:value];
			}
		}
		emailKeysEnumerator = [emailValueKeys objectEnumerator];
		while (key = [emailKeysEnumerator nextObject]) {
			if (value = [person valueForKeyPath:key]) {
				if ([allEmailsSet containsObject:value]) {
					[doubledEmailsSet addObject:value];
				}
				[allEmailsSet addObject:value];
			}
		}
	}
	
	[dataSource autorelease];
	dataSource = [[NSArray alloc] initWithObjects:[doubledPhonesSet allObjects], [doubledEmailsSet allObjects], nil];
	
	if ([self isWindowLoaded] == NO) {
		[self window];
	}
	[outlineView reloadData];
	[outlineView expandItem:[dataSource objectAtIndex:0]];
	[outlineView expandItem:[dataSource objectAtIndex:1]];
	[self showWindow:nil];
}

- (IBAction)findSelection:(id)sender
{
	int	row		= [outlineView selectedRow];
	id	object;
	if (row >= 0 && row < [outlineView numberOfRows]) {
		object	= [outlineView itemAtRow:row];
		
		if ([outlineView levelForRow:row] == 1) {
			int option = [[dataSource objectAtIndex:0] containsObject:object] ? AHKABSearchEveryPhoneNumber : AHKABSearchEveryEmailAddress;
			[windowController searchForString:[object description] options:option];
		}
	}
}

@end
